<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_LocationList
{
    protected static $instance;

    /**
     * @var XenCentral_AdServer_Locations_Abstract[]
     * Private variable and can be modified by _registerLocation/_removeLocation method only
     */
    private $location_list;

    /**
     * @var XenCentral_AdServer_Locations_Abstract[]
     * Stores location objects for template hooks, for faster access
     */
    private $hook_locations;

    public function __construct()
    {
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountAlertsAfterPosts');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountAlertsAfterProfilePosts');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountAlertsExtra');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountFollowingMemberlist');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPersonalDetailsAbout');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPersonalDetailsBiometrics');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPersonalDetailsInformation');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPersonalDetailsStatus');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPreferencesLocale');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AccountPrivacyBottom');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdHeader');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdMemberViewAboveMessages');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdMemberViewBelowAvatar');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdMemberViewSidebarBottom');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdMessageBelow');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdMessageBody');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdSidebarBelowVisitorPanel');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdSidebarBottom');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdSidebarTop');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdThreadViewAboveMessages');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AdThreadViewBelowMessages');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AfterContent');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AfterFooter');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AfterForumListNodes');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AfterHeaderLogo');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_AfterPagenodeContainerArticle');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BeforeContent');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BeforeFooter');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BeforeForumListNodes');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BeforeHeaderLogo');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BodyEnd');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BodyStart');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BreadcrumbBottom');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_BreadcrumbTop');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ContainerContentTop');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_FooterCopyright');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_FooterLinksLegal');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ForumViewPagenavBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ForumViewThreadsBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_HelpIndexExtra');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MemberViewInfoBlock');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MemberViewSidebarEnd');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MemberViewSidebarMiddle1');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MemberViewSidebarMiddle2');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MemberViewSidebarStart');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageContentAfter');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageContentBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageUserInfoAvatar');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageUserInfoExtraAfter');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageUserInfoExtraBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_MessageUserInfoText');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_NodeForumLevel2BeforeLastpost');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_Notices');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_PageTitle');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_SearchPopup');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_SidebarBottom');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_SidebarTop');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThreadCreateFieldsExtra');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThreadCreateFieldsMain');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThreadViewPagenavBefore');

        /* XenPorta hooks */
        /*$this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewPagenavBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewFormBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewQrBefore');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewQrAfter');
        $this->_registerLocationByClass('XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewShareAfter');*/
        /* End XenPorta hooks */

        $this->_registerLocationByClass('XenCentral_AdServer_Locations_CustomHook');

        $this->_registerCustomLocations();
    }

    /**
     * @return XenCentral_AdServer_LocationList
     */
    public static function getInstance()
    {
        if (is_null(self::$instance)) {
            $className=XenForo_Application::resolveDynamicClass(__CLASS__);
            self::$instance = new $className;
        }
        return self::$instance;
    }

    /**
     * @param $hookName
     * @return XenCentral_AdServer_Locations_Hooks_Abstract[]
     */
    public function getLocationsByHookName($hookName)
    {
        if(isset($this->hook_locations[$hookName])) {
            return $this->hook_locations[$hookName];
        }
        return array();
    }

    /**
     * @return XenCentral_AdServer_Locations_CustomHook
     */
    public function getCustomHookLocation()
    {
        return $this->hook_locations['custom_hook'][0];
    }

    public function getLocationById($location_id)
    {
        return $this->location_list[$location_id];
    }

    /**
     * @return \XenCentral_AdServer_Locations_Hooks_Abstract[]
     */
    public function getHookLocations()
    {
        return $this->hook_locations;
    }

    /**
     * @return \XenCentral_AdServer_Locations_Abstract[]
     */
    public function getLocationList()
    {
        return $this->location_list;
    }

    public function getGroupedLocationList()
    {
        $groupedList=array(
            'groups' => array(),
            'subgroups' => array(),
            'locations'=>array()
        );

        foreach($this->location_list AS $locationId=>$location)
        {
            $groupName=$location->getGroup();
            if ($groupName instanceof XenForo_Phrase) {
                $groupId = $groupName->getPhraseName();
            } else {
                $groupId = $groupName;
            }

            $subGroupName=$location->getSubGroup();
            if ($subGroupName instanceof XenForo_Phrase) {
                $subGroupId = $subGroupName->getPhraseName();
            } else {
                $subGroupId = $subGroupName;
            }

            $groupedList['groups'][$groupId] = $groupName;
            $groupedList['subgroups'][$subGroupId] = $subGroupName;
            $groupedList['locations'][$groupId][$subGroupId][$location->getLocationId()]=$location;
        }

        return $groupedList;
    }

    protected function _registerLocationByClass($class)
    {
        /** @var XenCentral_AdServer_Locations_Abstract $location */
        try {
            $class = XenForo_Application::resolveDynamicClass($class);
            $location = new $class;
        } catch(Exception $ex) {
            if(XenForo_Application::debugMode()) {
                throw $ex;
            }
            // just ignore incorrect errors
        }

        $this->_registerLocation($location);
    }

    /**
     * Can be used by third-parties to listen to class creation
     * and override this method to register their locations
     */
    protected function _registerCustomLocations()
    {

    }

    /**
     * @param $location
     */
    protected function _registerLocation(XenCentral_AdServer_Locations_Abstract $location)
    {
        $this->location_list[$location->getLocationId()] = $location;
        if($location instanceof XenCentral_AdServer_Locations_Hooks_Abstract) {
            $this->hook_locations[$location->getHookName()][]=$location;
        }

    }
}